#!/bin/sh

DIR=$PWD
DIROLD=$DIR
ROUTE=$0
NF=$((`echo -n $ROUTE | tr -c -d '/' | wc -c`))
if [[ $NF > 0 ]] ; then 
 ROUTE=`echo -n $ROUTE | cut --delimiter='/' --fields=1-$NF`
else 
 ROUTE=""
fi
DIR=$DIR/$ROUTE/..

cd $DIR

edg-job-get-output --input log/jobids

CNT=0
for ID in `cat log/jobids | grep -v "#"` ; do
 PROGRAMS=""
 for LINE in `cat inp/arg.list | tr ' ' '^' | tr '\t' '^'` ; do
  if [[ `echo -n "$LINE" | cut -c 1` == '#' ]] ; then continue ; fi
  LINE=`echo -n "$LINE" | tr '^' ' '`
  PROGRAMS="$PROGRAMS^$LINE"
 done
 PROGRAM=`echo -n "$PROGRAMS" | cut --delimiter='^' --fields=$(($CNT+2))`
 PROGRAM=`echo -n "$PROGRAM" | cut --delimiter=' ' --fields=1`
 echo "Storing output of $PROGRAM.$CNT ..."
 NFIELDS=$(($((`echo -n $ID | tr -c -d '/' | wc -c`))+1))
 ID=`echo -n $ID | cut --delimiter='/' --fields=$NFIELDS`
 mv /tmp/jobOutput/"$USER"_"$ID" out/$PROGRAM.$CNT
 cd out/$PROGRAM.$CNT
 tar -xzf out.tar.gz
 rm -f out.tar.gz
 cd ../..
 CNT=$(($CNT+1))
done

cd $DIROLD
