#!/bin/sh


#################### User definitions section. #########################


### Virtual Organization:
VO=cms

### Destination Storage Element:
DEST=grid100.kfki.hu


#################### End of user definitions section. ##################


IN=$1
OUT=$2

N=$((`echo -n "$IN" | wc -c`))
if [[ `echo -n "$IN" | cut -c $N-` == "/" ]] ; then
 IN=`echo -n "$IN" | cut -c -$(($N-1))`
fi
N=$((`echo -n "$OUT" | wc -c`))
if [[ `echo -n "$OUT" | cut -c $N-` == "/" ]] ; then
 OUT=`echo -n "$OUT" | cut -c -$(($N-1))`
fi

if ( echo -n "$IN" | grep "/grid" >&/dev/null ) ; then
 LIST=`lfc-ls -R $IN`
else
 LIST=`ls -R $IN`
fi

DIRLIST=`echo -n "$LIST" | grep ":" | tr -d ':'`

NBEGIN=$((`echo -n "$IN" | tr -c -d '/' | wc -c`))
INDIR=""
OUTDIR=""
for F in `echo -n "$LIST"` ; do
 if ( echo -n "$IN" | grep "/grid" >&/dev/null ) ; then
  if ( echo -n "$F" | grep ":" >&/dev/null ) ; then
   INDIR=`echo -n "$F" | tr -d ':'`
   N=$((`echo -n "$F" | tr -c -d '/' | wc -c`))
   D=`echo -n "$F" | cut --delimiter='/' --fields=$(($NBEGIN+1))-$(($N+1)) | tr -d ':'`
   OUTDIR=$OUT/$D
   echo "lfc-mkdir -m 775 $OUTDIR"
   lfc-mkdir -m 775 $OUTDIR
  else
   if ( echo -n "$F" | grep "/" >&/dev/null ) ; then
    N=$((`echo -n "$F" | tr -c -d '/' | wc -c`))
    FILE=`echo -n "$F" | cut --delimiter='/' --fields=$(($N+1))`
    if ! ( lfc-ls -l $OUT >&/dev/null ) ; then
     echo "lcg-cr --vo $VO -d $DEST -l lfn:$OUT lfn:$IN"
     RESULT=1
     while (( $RESULT != 0 )) ; do
      lcg-cr --vo $VO -d $DEST -l lfn:$OUT lfn:$IN
      RESULT=$?
      if (( $RESULT != 0 )) ; then sleep 1m ; fi
     done
     lfc-chmod 664 $OUT
     exit 0
    else
     echo "lcg-cr --vo $VO -d $DEST -l lfn:$OUT/$FILE lfn:$IN"
     RESULT=1
     while (( $RESULT != 0 )) ; do
      lcg-cr --vo $VO -d $DEST -l lfn:$OUT/$FILE lfn:$IN
      RESULT=$?
      if (( $RESULT != 0 )) ; then sleep 1m ; fi
     done
     lfc-chmod 664 $OUT/$FILE
     exit 0
    fi
   else
    FILE=$F
    if ! ( echo "$DIRLIST" | grep "$INDIR/$FILE" >&/dev/null ) ; then
     echo "lcg-cr --vo $VO -d $DEST -l lfn:$OUTDIR/$FILE lfn:$INDIR/$FILE"
     RESULT=1
     while (( $RESULT != 0 )) ; do
      lcg-cr --vo $VO -d $DEST -l lfn:$OUTDIR/$FILE lfn:$INDIR/$FILE
      RESULT=$?
      if (( $RESULT != 0 )) ; then sleep 1m ; fi
     done
     lfc-chmod 664 $OUTDIR/$FILE
    fi
   fi
  fi
 else
  if ( echo -n "$F" | grep ":" >&/dev/null ) ; then
   INDIR=`echo -n "$F" | tr -d ':'`
   N=$((`echo -n "$F" | tr -c -d '/' | wc -c`))
   D=`echo -n "$F" | cut --delimiter='/' --fields=$(($NBEGIN+1))-$(($N+1)) | tr -d ':'`
   OUTDIR=$OUT/$D
   echo "lfc-mkdir -m 775 $OUTDIR"
   lfc-mkdir -m 775 $OUTDIR
  else
   if ( echo -n "$F" | grep "/" >&/dev/null ) ; then
    N=$((`echo -n "$F" | tr -c -d '/' | wc -c`))
    FILE=`echo -n "$F" | cut --delimiter='/' --fields=$(($N+1))`
    if ! ( lfc-ls -l $OUT >&/dev/null ) ; then
     echo "lcg-cr --vo $VO -d $DEST -l lfn:$OUT file:$IN"
     RESULT=1
     while (( $RESULT != 0 )) ; do
      lcg-cr --vo $VO -d $DEST -l lfn:$OUT file:$IN
      RESULT=$?
      if (( $RESULT != 0 )) ; then sleep 1m ; fi
     done
     lfc-chmod 664 $OUT
     exit 0
    else
     echo "lcg-cr --vo $VO -d $DEST -l lfn:$OUT/$FILE file:$IN"
     RESULT=1
     while (( $RESULT != 0 )) ; do
      lcg-cr --vo $VO -d $DEST -l lfn:$OUT/$FILE file:$IN
      RESULT=$?
      if (( $RESULT != 0 )) ; then sleep 1m ; fi
     done
     lfc-chmod 664 $OUT/$FILE
     exit 0
    fi
   else
    FILE=$F
    if ! ( echo "$DIRLIST" | grep "$INDIR/$FILE" >&/dev/null ) ; then
     echo "lcg-cr --vo $VO -d $DEST -l lfn:$OUTDIR/$FILE file:$INDIR/$FILE"
     RESULT=1
     while (( $RESULT != 0 )) ; do
      lcg-cr --vo $VO -d $DEST -l lfn:$OUTDIR/$FILE file:$INDIR/$FILE
      RESULT=$?
      if (( $RESULT != 0 )) ; then sleep 1m ; fi
     done
     lfc-chmod 664 $OUTDIR/$FILE
    fi
   fi
  fi
 fi
done
