#!/bin/sh


#################### User definitions section. #########################


### The configuration file of the job to be run:
## A test job:
JOBCFG=test/demo.cfg
## Event generation + full simulation and reconstruction:
#JOBCFG=test/EvtGen+DetSim+Digi.cfg
## Single mu event generation:
#JOBCFG=test/single_mu_pt_5_simulation.cfg
## Local reconstruction (hit finding):
#JOBCFG=test/single_mu_pt_5_local_reconstruction.cfg
## CTF-KF track reconstruction:
#JOBCFG=test/single_mu_pt_5_ctfkf_track_reconstruction.cfg

### Output directories to be cleared:
OUTDIRS="out/bplots out/data out/hist out/plots"


#################### End of user definitions section. ##################

### Get directory, where the programs are located:
DIR=$PWD
DIROLD=$DIR
ROUTE=$0
NF=$((`echo -n $ROUTE | tr -c -d '/' | wc -c`))
if [[ $NF > 0 ]] ; then
   ROUTE=`echo -n $ROUTE | cut --delimiter='/' --fields=1-$NF`
else
   ROUTE=""
fi
DIR=$DIR/$ROUTE/..

### Change to directory, where the programs are located:
cd $DIR

### Set up environment:
eval `scramv1 runtime -sh`

### Compile:
#scramv1 build
scramv1 build --fast

### Clear up old results:
for f in $OUTDIRS ; do
    rm -rf $f/*
done

### Run:
cmsRun $JOBCFG

### Change to original directory: 
cd $DIROLD
