{
  // book histograms
  TFile histofile("track_hists.root","RECREATE");
  TH1F* h_pttr = new TH1F("pttr","Transverse Momentum for Single Muons",675,0.0,27.0);
  h_pttr->GetXaxis()->SetTitle("p_T [GeV]");
  h_pttr->GetYaxis()->SetTitle("Events");
  TH1F* h_pttr_5 = new TH1F("pttr_5","Transverse Momentum for 5 GeV Single Muons",100,3.0,7.0);
  h_pttr_5->GetXaxis()->SetTitle("p_T [GeV]");
  h_pttr_5->GetYaxis()->SetTitle("Events");
  TH1F* h_pttr_10 = new TH1F("pttr_10","Transverse Momentum for 10 GeV Single Muons",100,8.0,12.0);
  h_pttr_10->GetXaxis()->SetTitle("p_T [GeV]");
  h_pttr_10->GetYaxis()->SetTitle("Events");
  TH1F* h_pttr_15 = new TH1F("pttr_15","Transverse Momentum for 15 GeV Single Muons",100,13.0,17.0);
  h_pttr_15->GetXaxis()->SetTitle("p_T [GeV]");
  h_pttr_15->GetYaxis()->SetTitle("Events");
  TH1F* h_pttr_25 = new TH1F("pttr_25","Transverse Momentum for 25 GeV Single Muons",100,23.0,27.0);
  h_pttr_25->GetXaxis()->SetTitle("p_T [GeV]");
  h_pttr_25->GetYaxis()->SetTitle("Events");

  TTree *tree_5 = (TTree*)file_5.Get("Events");
  std::vector<reco::Track> trackCollection_5;
  TBranch *branch_5 = tree_5->GetBranch("recoTracks_TrackProducer__TrackReconstruction.obj");
  branch_5->SetAddress(&trackCollection_5);

  for ( unsigned int index = 0; index < tree_5->GetEntries(); ++index ) {
    if ( (index+1)%100 == 0 )
      std::cout << "Event: " << index+1 << std::endl;
    branch_5->GetEntry(index);
    for ( unsigned int bindex = 0; bindex < trackCollection_5.size(); ++bindex ) {
      reco::Track* track = (reco::Track*)trackCollection_5[bindex];
      double pT = sqrt(track->px()*track->px()+track->py()*track->py());
      h_pttr->Fill(pT);
      h_pttr_5->Fill(pT);
    }
  }
  
  TTree *tree_10 = (TTree*)file_10.Get("Events");
  std::vector<reco::Track> trackCollection_10;
  TBranch *branch_10 = tree_10->GetBranch("recoTracks_TrackProducer__TrackReconstruction.obj");
  branch_10->SetAddress(&trackCollection_10);

  for ( unsigned int index = 0; index < tree_10->GetEntries(); ++index ) {
    if ( (index+1)%100 == 0 )
      std::cout << "Event: " << index+1 << std::endl;
    branch_10->GetEntry(index);
    for ( unsigned int bindex = 0; bindex < trackCollection_10.size(); ++bindex ) {
      reco::Track* track = (reco::Track*)trackCollection_10[bindex];
      double pT = sqrt(track->px()*track->px()+track->py()*track->py());
      h_pttr->Fill(pT);
      h_pttr_10->Fill(pT);
    }
  }
  
  TTree *tree_15 = (TTree*)file_15.Get("Events");
  std::vector<reco::Track> trackCollection_15;
  TBranch *branch_15 = tree_15->GetBranch("recoTracks_TrackProducer__TrackReconstruction.obj");
  branch_15->SetAddress(&trackCollection_15);

  for ( unsigned int index = 0; index < tree_15->GetEntries(); ++index ) {
    if ( (index+1)%100 == 0 )
      std::cout << "Event: " << index+1 << std::endl;
    branch_15->GetEntry(index);
    for ( unsigned int bindex = 0; bindex < trackCollection_15.size(); ++bindex ) {
      reco::Track* track = (reco::Track*)trackCollection_15[bindex];
      double pT = sqrt(track->px()*track->px()+track->py()*track->py());
      h_pttr->Fill(pT);
      h_pttr_15->Fill(pT);
    }
  }
  
  TTree *tree_25 = (TTree*)file_25.Get("Events");
  std::vector<reco::Track> trackCollection_25;
  TBranch *branch_25 = tree_25->GetBranch("recoTracks_TrackProducer__TrackReconstruction.obj");
  branch_25->SetAddress(&trackCollection_25);

  for ( unsigned int index = 0; index < tree_25->GetEntries(); ++index ) {
    if ( (index+1)%100 == 0 )
      std::cout << "Event: " << index+1 << std::endl;
    branch_25->GetEntry(index);
    for ( unsigned int bindex = 0; bindex < trackCollection_25.size(); ++bindex ) {
      reco::Track* track = (reco::Track*)trackCollection_25[bindex];
      double pT = sqrt(track->px()*track->px()+track->py()*track->py());
      h_pttr->Fill(pT);
      h_pttr_25->Fill(pT);
    }
  }
  
  // save histograms
  histofile.Write();
  //  histofile.Close();
}
