#include "Utilities/Configuration/interface/Architecture.h"
#include "TrackerReco/TkTrackingRegions/interface/TrackingRegion.h"
#include "TrackerReco/TkHitTriplets/src/HitTripletGeneratorFromPairAndLayersWithHelix.h"
#include "TrackerReco/TkHitTriplets/interface/ThirdHitRZPredictionWithHelix.h"
#include "TrackerReco/TkHitTriplets/interface/ThirdHitPredictionFromInvParabola.h"
#include "TrackerReco/TkHitPairs/interface/LayerHitMap.h"
#include "TrackerReco/TkHitPairs/interface/LayerHitMapLoop.h"

#include "TrackerReco/TkMSParametrization/interface/MultipleScatteringParametrisation.h"

#include "TrackerReco/PixelTrackFit/interface/CircleFromThreePoints.h"
#include "TrackerReco/TkMSParametrization/interface/PixelRecoPointRZ.h"

#include "MagneticField/BaseMagneticField/interface/MagneticField.h"
#include "ClassReuse/GeomVector/interface/GlobalPoint.h"

#undef Debug

#include <fstream>

void HitTripletGeneratorFromPairAndLayersWithHelix::
    hitTriplets( const TrackingRegion& region, OrderedHitTriplets & result ) 
{
#ifdef Debug
  cerr << "  [HitTripletGeneratorFromPairAndLayersWithHelix] start" << endl;
#endif

  OrderedHitPairs pairs; pairs.reserve(30000);
  OrderedHitPairs::const_iterator ip;
  thePairGenerator->hitPairs(region,pairs);

  if (pairs.size() ==0) return;

  int size = theLayers.size(); 

  // set aliases
  const LayerHitMap **thirdHitMap = new const LayerHitMap* [size];
  for (int il=0; il <=size-1; il++) {
     thirdHitMap[il] = &theLayerCache(theLayers[il], region);
  }

  for (ip = pairs.begin(); ip != pairs.end(); ip++) {
#ifdef Debug
    cerr << "  ---------------------------------------------------" << endl;
    fprintf(stderr,"  %c[31m[HitTripletGeneratorFromPairAndLayersWithHelix] process pair%c[m\n", 27,27);
#endif

    // Helix, constructor
    ThirdHitRZPredictionWithHelix
      prediction(region.originRBound(),
                 region.ptMin(),
                 RecHit((*ip).inner()).globalPosition(),
                 RecHit((*ip).outer()).globalPosition());

    for (int il=0; il <=size-1; il++) {
      const DetLayer * layer = theLayers[il];
//      bool barrelLayer = (layer->part() == barrel); 

      float tol = 0.1;

      // Helix
      float phi[2],rz[2];
      prediction.getRanges(layer, phi,rz);
      PixelRecoRange<float> phiRange(phi[0]-tol,phi[1]+tol);
      PixelRecoRange<float>  rzRange( rz[0]-tol, rz[1]+tol);

      LayerHitMapLoop thirdHits = thirdHitMap[il]->loop(phiRange, rzRange);

#ifdef Debug
      cerr << "  [HitTripletGeneratorFromPairAndLayersWithHelix]  thirdHits" << endl;
#endif

      const TkHitPairsCachedHit * th;
      while ( (th = thirdHits.getHit()) ) {
#ifdef Debug
         cerr << "  [HitTripletGeneratorFromPairAndLayersWithHelix]  check" << endl;
#endif

         GlobalPoint p3 = RecHit(*th).globalPosition();

#ifdef Debug
         fprintf(stderr,
          "  [HitTripletGeneratorFromPairAndLayersWithHelix]  p3=(%.2f %.2f %.2f)\n",
          p3.x(), p3.y(), p3.z());

         ofstream outFile("out/p3.dat");
         outFile << p3.x() << " " << p3.y() << " " << p3.z() << endl; 
         outFile.close();
#endif

         bool compatible = prediction.isCompatible(p3);

#ifdef Debug
         fprintf(stderr,
          "  [HitTripletGeneratorFromPairAndLayersWithHelix]  compatible:%d\n",
          compatible);
while(getchar()==0);
#endif

         if(compatible == false)
           continue;

         RecHit h2 = (*ip).outer();
         RecHit h3 = *th;
         result.push_back( OrderedHitTriplet( 
             (*ip).inner(),
           OrderedHitTriplet::MiddleHit(h2),
           OrderedHitTriplet::OuterHit(h3)));
      }

#ifdef Debug
      cerr << "  [HitTripletGeneratorFromPairAndLayersWithHelix]  no more hits" << endl;
      cerr << "  [HitTripletGeneratorFromPairAndLayersWithHelix]  result = " << result.size() << endl;

      while(getchar() == 0);
#endif
    }

#ifdef Debug
    cerr << "  [HitTripletGeneratorFromPairAndLayersWithHelix] pair ready" << endl;
#endif
  } 
  delete [] thirdHitMap;

#ifdef Debug
  cerr << "  [HitTripletGeneratorFromPairAndLayersWithHelix] layer pair done" << endl;
#endif

  return;
}



