#ifndef _ClusterShape_H_
#define _ClusterShape_H_

#include "CommonDet/BasicDet/interface/RecHit.h"

#include "Tracker/SiPixelDet/interface/PixelDet.h"
#include "Tracker/SiPixelDet/interface/PixelDetType.h"

#include <fstream>

#define MaxSize 20

class ClusterShape
{
 public:
   ClusterShape();
   ~ClusterShape();
   bool checkPixelRecTrack
     (const vector<RecHit>& recHits, const vector<LocalVector>& localDirs);
   bool isCompatible(const RecHit *recHit, const LocalVector& dir);
   static void loadClusterShapeData();

 private:
   int getDirection(int low,int hig, int olow,int ohig);
   bool processColumn(pair<int,int> pos, bool inTheLoop);
   bool determineShape(const RecHit *recHit);
   bool getFlipped(const PixelDet* pixelDet);
   bool isInside(float a[2][2], float& wx, float& wy);
   void compareWithSimHit
     (const RecHit *recHit, const PixelDet* pixelDet, int dx,int dy);

   const PixelDet* pixelDet;
   int x[2],y[2], low,hig, olow,ohig, odir;

   static float limits[2][MaxSize + 1][2][MaxSize + 1][2][2][2];

   bool writeClusterShape;
};

#endif

