#ifndef _LowPtTrackFinder_h_
#define _LowPtTrackFinder_h_

#include "CARF/Reco/interface/ConfigAlgorithm.h"

#include "CommonReco/PatternTools/interface/TTrack.h"
#include "CommonReco/PatternTools/interface/RecTrack.h"
//#include "TrackerReco/GtfPattern/interface/RegionalTrackFinder.h"

class TrackingRegion;
class RegionalSeedGenerator;
class TrajectoryBuilder;
class TrajectorySmoother;
class TrajectoryCleaner;

class LowPtTrackFinder : public ConfigAlgorithm //, public RegionalTrackFinder
{
 public:   
   explicit LowPtTrackFinder(const RecConfig& config);  
   ~LowPtTrackFinder();
  
   static RecConfig defaultConfig();
   vector<RecTrack *> tracks( const TrackingRegion& region) const;
  
 private:

   RegionalSeedGenerator* theSeedGenerator;
   TrajectoryBuilder*     theTrajectoryBuilder;
   TrajectorySmoother*    theTrajectorySmoother;
   TrajectoryCleaner*     theTrajectoryCleaner;
   
   bool                   theSeedClean;

   void componentsInit();
  
};

#endif
