#include "Utilities/Configuration/interface/Architecture.h"

#include "CARF/Reco/interface/RecConfig.h"

#include "CARF/Reco/interface/ParameterSetBuilder.h"
#include "CARF/Reco/interface/ComponentSetBuilder.h"
#include "CARF/Reco/interface/RecCollection.h"
#include "CARF/Reco/interface/RecQuery.h"
#include "TrackerReco/PixelTrackFinder/interface/SeedGeneratorByRecTracksRecAlgo.h"

SeedGeneratorByRecTracksRecAlgo::SeedGeneratorByRecTracksRecAlgo(
    const RecConfig& config) : RecAlgorithm<SeedFromRecTrack>(config)
{
  theTracks = new TrackContainer(component("TrackFinder"));	
}

SeedGeneratorByRecTracksRecAlgo::~SeedGeneratorByRecTracksRecAlgo() 
{
  delete theTracks;	
}

RecConfig SeedGeneratorByRecTracksRecAlgo::defaultConfig()
{
  static Name n("SeedGeneratorByRecTracks");
  static Version v("1.0");
	
  ComponentSetBuilder cb;
  RecQuery trackFinder("PixelTrackFinder");
  cb.addComponent("TrackFinder", trackFinder);
    
  return RecConfig( n, v, ParameterSetBuilder().result(), cb.result());
}

void SeedGeneratorByRecTracksRecAlgo::reconstruct()
{
  typedef TrackContainer::const_iterator CI;
  for (CI i = theTracks->begin(); i != theTracks->end()  ; i++) {
    try {
      SeedFromRecTrack * seedPtr = new SeedFromRecTrack(*i);
      addObjToReconstructor( seedPtr );
    }
    catch( DetLogicError& err) { cout<<"Warning: "<<err.what()<<endl; }
  }
}

#include "Utilities/Notification/interface/PackageInitializer.h"
#include "CARF/Reco/interface/RecBuilder.h"
namespace {
  PKBuilder< RecBuilder<SeedGeneratorByRecTracksRecAlgo > >
                    sg("SeedGeneratorByRecTracksBuilder");
}

