#include "Utilities/Configuration/interface/Architecture.h"
#include "TrackerReco/PixelTrackFit/interface/HelixFromHitTriplet.h"
#include "MagneticField/BaseMagneticField/interface/MagneticField.h"

#include "CommonDet/BasicDet/interface/DetType.h"
#include "CommonDet/BasicDet/interface/DetUnit.h"

#include "ClassReuse/GeomVector/interface/Basic2DVector.h"

#include "TrackerReco/PixelTrackFit/interface/ZIPFromHelix2Order.h"

const double PI = 3.141593;

HelixFromHitTriplet::HelixFromHitTriplet(const vector<RecHit> & triplet, 
				     const GlobalPoint origin) 
  : theOrigin(origin), theTriplet(triplet), theCircle(0), theParabola(0),
    theRPhiIPCalculated(0),thePtCalculated(0), thePt(0), theRPhiIP(0)
{

  if (triplet.size() != 3 ){
    throw DetLogicError("HelixFromHitTriplet: they are not three hits");
  }
 //check if the recHits are valid
  const RecHit h1 = theTriplet[0];
  const RecHit h2 = theTriplet[1];
  const RecHit h3 = theTriplet[2];
  //@@@@@@@ is this control correct?
  if (!(h1.isValid() && h2.isValid() && h3.isValid())) {
    throw DetLogicError("HelixFromHitTriplet: one of hits is not valid");
  } else {
    theP1 = h1.globalPosition();
    theP2 = h2.globalPosition();
    theP3 = h3.globalPosition();
    theBarr1 = ((h1.det().detUnits().front())->type().part( ) == barrel); 
    theBarr2 = ((h2.det().detUnits().front())->type().part( ) == barrel);
    theErr1 = h1.globalPositionError();
    theErr2 = h2.globalPositionError();
    theCircle = new CircleFromThreePoints(theP1,theP2,theP3);
    theParabola = new ParabolaFromThreePoints(theP1,theP2,theP3);
    theRho = theCircle->curvature(); 
  }
}
HelixFromHitTriplet::~HelixFromHitTriplet(){
  delete theCircle;
  delete theParabola;
}

int HelixFromHitTriplet::charge()
{
   const RecHit h1 = theTriplet[0];
   const RecHit h2 = theTriplet[1];
   const RecHit h3 = theTriplet[2];
   GlobalPoint gp1 = h1.globalPosition();
   GlobalPoint gp2 = h2.globalPosition();
   
   
   GlobalVector v21 = gp2 -gp1;
   float dphi;
   
   GlobalPoint gp3 = h3.globalPosition();
   GlobalVector v32 = gp3 - gp2;
   dphi = v32.phi() - v21.phi();
   
   
   while (dphi >  M_PI) dphi -= 2*M_PI;
   while (dphi < -M_PI) dphi += 2*M_PI;
   return (dphi > 0) ? -1 : 1;
}

double HelixFromHitTriplet::rPhiIP(){
  if (theRho != 0) {
    Basic2DVector<float> center = theCircle->center();
    if ( pT() < 3.5 ) {
      theRPhiIP = 
	sqrt((center.x()*center.x())+(center.y()*center.y())) - 1/theRho;
      
     

       theRPhiIP *= charge();
       //       cout << " klkl " << theRPhiIP << " " << theRho << " " << sqrt((center.x()*center.x())+(center.y()*center.y())) << " " << theParabola->impactParameter() << " " << charge << " " << endl;

    }
    else {
      //GlobalPoint gCenter(center.x(),center.y(),0);
      //CircleCenterPlaneCrossing2OrderLocal intercept(theP1, theRho ,gCenter);
      theRPhiIP = theParabola->impactParameter();
    }
    theRPhiIPCalculated = true;
    return theRPhiIP;
  } else {
    return 0.;
  }
}



float HelixFromHitTriplet::pT() const{
  if (theRho != 0) {
    static float bField = (MagneticField::inTesla(GlobalPoint(0.,0.,0.))).z();
    return  3/1000. *bField / theRho; // pt in GeV and curvature in cm-1
  } else {
    return 0;
  }
}

float HelixFromHitTriplet::phi() const {
    return phiFromCircle();
}

float HelixFromHitTriplet::phiFromCircle() const{
  float xC = theCircle->center().x();
  float yC = theCircle->center().y();
/*
  float phiC = 0.;
  if (xC != 0 || yC != 0 ) phiC= acos( xC / sqrt( xC*xC + yC*yC) );
  if ( yC >= 0 ) {
    if ( xC < 0) phiC = phiC - PI/2.;
    else phiC = phiC + PI/2.;
  } else {
    if ( xC >= 0 ) phiC = PI/2.-phiC;
    else phiC = 3./2.*PI - phiC;
  } 
  // if (theP1.phi() < 0 && phiC > 0) phiC-=PI;
  if (theP1.phi() < 0 ) phiC-=PI;
  // cout<<"HelixFromHitTriplet::phiFromCircle "<<phiC<<" "<<theP1.phi()<<endl;
*/
  float phi1 = theP1.phi();
  float phiC = atan2(yC,xC) + M_PI/2;

  while(phiC < phi1 - M_PI/2) phiC += M_PI;
  while(phiC > phi1 + M_PI/2) phiC -= M_PI;

  return phiC;
}

float HelixFromHitTriplet::phiFromParabola() const{
  return theParabola->phi();
}

double HelixFromHitTriplet::zIP(){
  //  if (pT()<6) {
  //    setTransIP();
  //    double r0 = theRPhiIP;
    ZIPFromHelix2Order helix(theRho, theP1, theP2);
    theZIP = helix.zIntercept();
    // } else {
    //@@@ TEST to improve ZIP resolution
    // ZIPFromHelix2Order helix(theRho, theP1, theP2);
    //theZIP = helix.zIntercept();    
    //}
  return theZIP;
}

void HelixFromHitTriplet::setTransIP(){
  if (!theRPhiIPCalculated){
    theRPhiIP  = rPhiIP();
    theRPhiIPCalculated = true;
  }
}

void HelixFromHitTriplet::setPt(){
  if (!thePtCalculated){
    thePt  = pT();
    thePtCalculated = true;
  }
}

// try new implementation
double HelixFromHitTriplet::dZIP() {
  double ziperr=0;
  setPt();
  float pt = (thePt <= 10.) ? thePt: 10.;
  double p1=0, p2=0,p3=0,p4=0;
  float feta = fabs(theP3.eta());
  if (feta<=0.8){
    p1 = 0.12676e-1;
    p2 = -0.22411e-2;
    p3 = 0.2987e-3;
    p4 = -0.12779e-4;
  } else if (feta <=1.6){
    p1 = 0.24047e-1;
    p2 = -0.66935e-2;
    p3 = 0.88111e-3;
    p4 = -0.38482e-4;
  } else {
    p1 = 0.56084e-1;
    p2 = -0.13960e-1;
    p3 = 0.15744e-2;
    p4 = -0.60757e-4;
  }
  ziperr = p1 + p2*pt + p3*pt*pt +p4*pt*pt*pt;
  return ziperr*ziperr;
}

// parametrisation from Marcel Vos
/*
double HelixFromHitTriplet::dZIP() {
  setPt();
  float pt = (thePt <= 10.) ? thePt: 10.;
  double p1=0, p2=0;
  float feta = fabs(theP3.eta());
  if (feta<=0.8)
    {
      p1=7.5e-3;
      p2=4.2e-3;
    }
  else if (feta <=1.6){
    p1 = 7.3e-3;
    p2 = 9.9e-3;
  }
  else {
    p1 =  1.2e-02;
    p2 = 2.2e-2;
  }
  float err=0;
  if (pt != 0) err = (p1 + p2/pt);
  return err*err;
}
*/

// parametrisation from Marcel Vos
double HelixFromHitTriplet::dRPhiIP()
{
  setPt();
  float pt = (thePt <= 10.) ? thePt: 10.;
  double p1=0, p2=0;
  float feta = fabs(theP3.eta());
  if (feta<=0.8)
    {
      p1=5.9e-3;
      p2=4.7e-3;
    }
  else if (feta <=1.6){
    p1 = 4.9e-3;
    p2 = 7.1e-3;
  }
  else {
    p1 = 6.4e-3;
    p2 = 1.0e-2;
  }
  float err=0;
  if (pt != 0) err = (p1 + p2/pt);
  return err*err;
}

/*
double HelixFromHitTriplet::dZIP(){
  GlobalPoint p1min;
  GlobalPoint p1max;
  GlobalPoint p2min;
  GlobalPoint p2max;
  if (theBarr1) {
    float zerr = sqrt(theErr1.czz());
    p1min = GlobalPoint(theP1.x(), theP1.y(), theP1.z()-zerr);
    p1max = GlobalPoint(theP1.x(), theP1.y(), theP1.z()+zerr);
  } else {
    float xerr = sqrt(theErr1.cxx()); 
    float yerr = sqrt(theErr1.cyy()); 
    p1min = GlobalPoint(theP1.x()-xerr,	theP1.y()-yerr, theP1.z());
    p1max = GlobalPoint(theP1.x()+xerr,	theP1.y()+yerr, theP1.z());
  }
  if (theBarr2) {
    float zerr = sqrt(theErr2.czz());
    p2min = GlobalPoint(theP2.x(), theP2.y(), theP2.z()-zerr);
    p2max = GlobalPoint(theP2.x(), theP2.y(), theP2.z()+zerr);
  } else {
    float xerr = sqrt(theErr2.cxx()); 
    float yerr = sqrt(theErr2.cyy()); 
    p2min = GlobalPoint(theP2.x()-xerr,	theP2.y()-yerr, theP2.z());
    p2max = GlobalPoint(theP2.x()+xerr,	theP2.y()+yerr, theP2.z());
  }
  //  setTransIP();
  //  double r0 = theRPhiIP;
  ZIPFromHelix2Order helixMin(theRho, p1min, p2max);
  ZIPFromHelix2Order helixMax(theRho, p1max, p2min);
  double zipMax = helixMax.zIntercept(); 
  double zipMin = helixMin.zIntercept();   
  return (zipMax-zipMin)*(zipMax-zipMin)/4;
}
*/

