#include "Utilities/Configuration/interface/Architecture.h"

#include "TrackerReco/PixelTrackFit/interface/PixelTrack.h"

#include "MagneticField/BaseMagneticField/interface/MagneticField.h"

PixelTrack::PixelTrack(float pt, double rpip, double drpip2,
           double zip, double dzip2, float chi2, float phi,
           const vector<RecHit> & trhits):
    thePt(pt),
    thePhi(phi),
    theZIP(zip), theZIPError2(dzip2),
    theRPhiIP(rpip), theRPhiIPError2(drpip2),
    theChi2(chi2), theHits(trhits)
  {

    theErrPt = 0.055*thePt  + 0.017*thePt*thePt;
    theErrPhi = 0.002;
    theErrCotTheta = 0.002;   

    //    thePhi = (theHits.size() >=1) ? theHits[0].globalPosition().phi() : 0.;
    if (theHits.size() >= 2) {
      GlobalPoint gp1 = theHits[0].globalPosition();
      GlobalPoint gp2 = theHits[1].globalPosition();

      GlobalVector v21 = gp2 -gp1;
      float dphi;
      if (theHits.size() >=3) {
        GlobalPoint gp3 = theHits[theHits.size()-1].globalPosition();
        GlobalVector v32 = gp3 - gp2;
        dphi = v32.phi() - v21.phi();
      } 
      else {
        dphi = v21.phi() - thePhi;
      }
      while (dphi >  M_PI) dphi -= 2*M_PI;
      while (dphi < -M_PI) dphi += 2*M_PI;
      theCharge =  (dphi > 0) ? -1 : 1;

      static float bField = (MagneticField::inTesla(GlobalPoint(0.,0.,0.))).z();

      float radius = thePt / (3/1000. * bField);
//      float chi = thePhi + theCharge * M_PI_2;
//      GlobalPoint IP(theRPhiIP*cos(chi), theRPhiIP*sin(chi),theZIP);
      float chi = thePhi - M_PI_2;
      GlobalPoint IP(theRPhiIP*cos(chi), theRPhiIP*sin(chi),theZIP);

      float phi1 = 2*asin(0.5*(gp1 - IP).perp()/radius);
      float phi2 = 2*asin(0.5*(gp2 - IP).perp()/radius);

      float dr = radius*(phi2 - phi1);
      float dz = gp2.z()-gp1.z();

      // Recalculate ZIP
      theZIP = (gp1.z()*phi2 - gp2.z()*phi1)/(phi2 - phi1);

      theCotTheta = (fabs(dr) > 1.e-3) ? dz/dr : 0;
    }
    else {
      theCotTheta = 0.;
      theCharge = 0;
    }
  }
