#ifndef HitTripletGeneratorFromPairAndLayersWithHelix_H
#define HitTripletGeneratorFromPairAndLayersWithHelix_H

#include "TrackerReco/TkHitTriplets/src/HitTripletGeneratorFromPairAndLayers.h"

class   HitTripletGeneratorFromPairAndLayersWithHelix :
 public HitTripletGeneratorFromPairAndLayers {

public:

  HitTripletGeneratorFromPairAndLayersWithHelix(
      const HitPairGenerator & generator,
      vector<const DetLayer*> layers,
      LayerCacheType* layerCache)
    : HitTripletGeneratorFromPairAndLayers(generator, layers, layerCache),
      thePairGenerator(generator.clone()),
      theLayers(layers),
      theLayerCache(*layerCache)
    { }

  ~HitTripletGeneratorFromPairAndLayersWithHelix() { delete thePairGenerator; }

  virtual void hitTriplets(
      const TrackingRegion& region, OrderedHitTriplets & trs);

private:
  bool isNotMarked(RecHit& recHit);
  HitPairGenerator * thePairGenerator;
  vector<const DetLayer*> theLayers;
  LayerCacheType & theLayerCache;
};

#endif
