#include "Utilities/Configuration/interface/Architecture.h"
#include "TrackerReco/TkTrackingRegions/interface/TrackingRegion.h"
#include "TrackerReco/TkHitTriplets/interface/HitTripletGeneratorFromPairAndLayersWithHelix.h"
#include "TrackerReco/TkHitTriplets/interface/ThirdHitRZPredictionWithHelix.h"
#include "TrackerReco/TkHitTriplets/interface/ThirdHitPredictionFromInvParabola.h"
#include "TrackerReco/TkHitPairs/interface/LayerHitMap.h"
#include "TrackerReco/TkHitPairs/interface/LayerHitMapLoop.h"

#include "TrackerReco/TkMSParametrization/interface/MultipleScatteringParametrisation.h"

#include "TrackerReco/PixelTrackFit/interface/CircleFromThreePoints.h"
#include "TrackerReco/TkMSParametrization/interface/PixelRecoPointRZ.h"

#include "ClassReuse/GeomVector/interface/GlobalPoint.h"

#include "TrackerReco/LowPt/interface/ClusterShape.h"

#include <fstream>

#include "Utilities/UI/interface/SimpleConfigurable.h"

void HitTripletGeneratorFromPairAndLayersWithHelix::
    hitTriplets( const TrackingRegion& region, OrderedHitTriplets & result ) 
{
  bool checkClusterShape =
      SimpleConfigurable<bool>(true, "LowPt:checkClusterShape").value();

  bool limitTriplets =
      SimpleConfigurable<bool>(true, "LowPt:limitTriplets").value();

  OrderedHitPairs pairs; pairs.reserve(30000);
  OrderedHitPairs::const_iterator ip;
  thePairGenerator->hitPairs(region,pairs);

  if (pairs.size() ==0) return;

  int size = theLayers.size(); 

  // set aliases
  const LayerHitMap **thirdHitMap = new const LayerHitMap* [size];
  for (int il=0; il <=size-1; il++)
     thirdHitMap[il] = &theLayerCache(theLayers[il], region);

  for (ip = pairs.begin(); ip != pairs.end(); ip++)
  {
    // Helix, constructor
    ThirdHitRZPredictionWithHelix
      prediction(region.originRBound(),
                 region.ptMin(),
                 RecHit((*ip).inner()).globalPosition(),
                 RecHit((*ip).outer()).globalPosition());

    for (int il=0; il <=size-1; il++) {
      const DetLayer * layer = theLayers[il];

      // Helix
      float phi[2],rz[2];
      prediction.getRanges(layer, phi,rz);
      PixelRecoRange<float> phiRange(phi[0]-0.03,phi[1]+0.03);
      PixelRecoRange<float>  rzRange( rz[0]-0.30, rz[1]+0.30);

      LayerHitMapLoop thirdHits = thirdHitMap[il]->loop(phiRange, rzRange);

      const TkHitPairsCachedHit * th;

      while ( (th = thirdHits.getHit()) )
      {
         RecHit hit3 = RecHit(*th); 

         GlobalPoint p3 = RecHit(*th).globalPosition();

         vector<RecHit> recHits;
         recHits.push_back((*ip).inner());
         recHits.push_back((*ip).outer());
         recHits.push_back(*th);

         bool proper = true;

         if(limitTriplets)
         {
           if(!(recHits[0].layer()->part() == barrel &&
                recHits[0].globalPosition().perp2() < 6*6)) proper = false;

           if(!(recHits[1].layer()->part() == barrel &&
                recHits[1].globalPosition().perp2() < 9*9)) proper = false;

           if(!(fabs(recHits[2].globalPosition().z()) < 40)) proper = false;
         } 

         if(proper == false) continue;

         vector<GlobalVector> globalDirs;
         float momentum;
         int charge;
         bool compatible = prediction.isCompatible(p3, globalDirs, momentum,charge);

         if(compatible == false)
           continue;

         vector<GlobalVector> momenta;
         momenta.push_back(globalDirs[0] * momentum);
         momenta.push_back(globalDirs[1] * momentum);
         momenta.push_back(globalDirs[2] * momentum);

         // globalDir -> localDir
         vector<LocalVector> localDirs; // !!!
         vector<GlobalVector>::const_iterator globalDir = globalDirs.begin();
         for(vector<RecHit>::const_iterator recHit  = recHits.begin();
                                            recHit != recHits.end(); recHit++)
         {
           localDirs.push_back(recHit->det().toLocal(*globalDir));
           globalDir++;
         }

         if(checkClusterShape)
         {
           ClusterShape theClusterShape;
           if(theClusterShape.checkPixelRecTrack(recHits,localDirs) == false)
             continue;
         }

         RecHit h2 = (*ip).outer();
         RecHit h3 = *th;
         result.push_back( OrderedHitTriplet( 
             (*ip).inner(),
           OrderedHitTriplet::MiddleHit(h2),
           OrderedHitTriplet::OuterHit(h3)));
      }
    }
  }
  delete [] thirdHitMap;

  return;
}


