#ifndef _ClusterInfo_h_
#define _ClusterInfo_h_

#include "FWCore/Framework/interface/Event.h"

#include "DataFormats/TrackerRecHit2D/interface/SiPixelRecHitCollection.h"
#include "Geometry/TrackerGeometryBuilder/interface/TrackerGeometry.h"
#include "Geometry/Vector/interface/LocalVector.h"
#include "RecoPixelVertexing/PixelTriplets/interface/ClusterData.h"

#include <utility>
#include <vector>

using namespace std;

#define MaxSize 20

class ClusterInfo
{
 public:
   ClusterInfo(const SiPixelRecHitCollection& theHits,
               const edm::EventSetup& es);
   ClusterInfo();
   ~ClusterInfo();
   ClusterData getExtra(const SiPixelRecHit* recHit);
   bool checkTrack(vector<const TrackingRecHit*> recHits,
                   vector<LocalVector> localDirs);

 private:
   void processHits(const SiPixelRecHitCollection& theHits); 
   void loadClusterLimits();
   bool isInside(float a[2][2], pair<float,float> movement);
   bool isCompatible
     (const SiPixelRecHit *recHit, const LocalVector& dir);

   const TrackerGeometry* theTracker;

   static bool isFirst;
   static float limits[2][MaxSize + 1][2][MaxSize + 1][2][2][2];
   static map<DetId, map<const SiPixelRecHit*,ClusterData> > data_;
};

#endif
