#ifndef _HitTripletGeneratorFromPairAndLayersWithHelix_h_
#define _HitTripletGeneratorFromPairAndLayersWithHelix_h_

#include "RecoPixelVertexing/PixelTriplets/interface/HitTripletGeneratorFromPairAndLayers.h"

class   HitTripletGeneratorFromPairAndLayersWithHelix :
 public HitTripletGeneratorFromPairAndLayers {

 typedef PixelHitTripletGenerator::LayerCacheType       LayerCacheType;

 public:
   HitTripletGeneratorFromPairAndLayersWithHelix
     (const HitPairGenerator& generator,
      vector<const LayerWithHits*> layers,
      LayerCacheType* layerCache)
    : HitTripletGeneratorFromPairAndLayers(generator, layers, layerCache),
      thePairGenerator(generator.clone()),
      theLayers(layers),
      theLayerCache(*layerCache)
   { theTracker = 0; }

   ~HitTripletGeneratorFromPairAndLayersWithHelix()
   { delete thePairGenerator; }

   virtual void hitTriplets(const TrackingRegion& region, OrderedHitTriplets & trs, const edm::EventSetup& es);

 private:
   void getTracker (const edm::EventSetup& es);
   GlobalPoint getGlobalPosition(const TrackingRecHit* recHit);
   GlobalPoint localToGlobal(const TrackingRecHit* recHit);  

   const TrackerGeometry* theTracker;

   HitPairGenerator * thePairGenerator;
   vector<const LayerWithHits*> theLayers;
   LayerCacheType & theLayerCache;
};

#endif
