void clusterShape()
{
  // Plain style
  gROOT->SetStyle("Plain");

  TCanvas c1;
  c1.Divide(2,2);

  // Open file
  TFile file("clusterShape.root","read");
  file.ls();
  TNtuple * ntuple = (TNtuple *) file.Get("clusterShape");

  ntuple->SetMarkerStyle(kDot);

  TPostScript ps("clusterShape.ps",112);
  ps.Range(26,20);

  TCut cut = "subdet==0 && branch==1 && abs(mx)<6 && abs(my)<6";

  c1.cd(1); ntuple->Draw("my:mx",cut + "ex==0 && ey==2");
  c1.Update();

  c1.cd(2); ntuple->Draw("my:mx",cut + "ex==1 && ey==1");
  c1.Update();

  c1.cd(3); ntuple->Draw("my:mx",cut + "ex==2 && ey==0");
  c1.Update();

  c1.cd(4); ntuple->Draw("my:mx",cut + "ex==1 && ey==3");
  c1.Update();

  ps.Close();
}
