#include "RecoTracker/TkMSParametrization/interface/MultipleScatteringX0Data.h"

#include <iostream>
#include <string>

#include "TH2F.h"
#include "TFile.h"
#include "TKey.h"


MultipleScatteringX0Data::MultipleScatteringX0Data() : theData(0)
{
  std::cout << "MultipleScatteringX0Data initialisation,";
  std::string filename = fileName(); 
  std::cout <<" reading :"<<filename.c_str()<<"..."<<std::endl;

  file = new TFile(filename.c_str(),"read");
//  file->ls();
  theData = (TH2F*) file->Get("h2");

  std::cout << "..done, data title: "<< theData->GetTitle() << std::endl;

  theData->GetXaxis()->SetLimits(0.,3.);
  theData->GetYaxis()->SetLimits(0.,15.);
}

MultipleScatteringX0Data::~MultipleScatteringX0Data()
{
  file->Close();
}

std::string MultipleScatteringX0Data::fileName()
{
  return "/afs/cern.ch/user/s/sikler/public/data/MultipleScatteringX0Data_pixel.root";
} 

int MultipleScatteringX0Data::nBinsEta() const
{
  return theData ? theData->GetXaxis()->GetNbins() : 0;
}

float MultipleScatteringX0Data::minEta() const
{
  return theData ? theData->GetXaxis()->GetXmin() : 0.;
}

float MultipleScatteringX0Data::maxEta() const
{
  return theData ? theData->GetXaxis()->GetXmax() : 0.; 
}

float MultipleScatteringX0Data::sumX0atEta(float eta, float r) const
{
  if (!theData) return 0.;

/*
  for(float x=0.05; x<3. ; x+=0.1)
  for(float y=0.5 ; y<15.; y+=1. )
  {
   int ieta = theData->GetXaxis()->FindFixBin(x);
   int irad = theData->GetYaxis()->FindFixBin(y);

   std::cerr << "table " << x << " " << y
             << " " << theData->GetBinContent(ieta,irad) << std::endl;
  }
  exit(1);
*/

  const double epsilon = 1.e-10;
  eta = fabs(eta);

  int ieta = theData->GetXaxis()->FindFixBin(eta);
  int irad = theData->GetYaxis()->FindFixBin(r);

  if (irad < theData->GetYaxis()->GetNbins())
  {
/*
    std::cerr << "data " << eta 
              << " " << r
              << " " << ieta
              << " " << irad
              << " " << theData->GetBinContent(ieta,irad) << std::endl;
*/
    return theData->GetBinContent(ieta,irad);
  } 
  else
  {
    float sumX0 = 0.;
    for(int ir = theData->GetYaxis()->GetNbins()-1; ir >= 0; ir--)
    {
      float val = theData->GetBinContent(ieta,ir+1);
      if (val > sumX0+epsilon) sumX0 = val;
    }

    return sumX0;
  }
}
